﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class RegistryInstrumentMaster : System.Web.UI.MasterPage
{
    private UserAccountManager _currentUser;
    protected void Page_Load(object sender, EventArgs e)
    {

        //Sets the correct URL for context sensitive help, based on content page
        if (!AccessAllowed())
        {
            //Response.Redirect("ErrorPage.aspx?id=100");
            HyperLinkReporting.Visible = false;
        }
        else
        {
            HyperLinkHelp.NavigateUrl = GetContextSensitiveHelpURL();
            HyperLinkReporting.Visible = true;
            HyperLinkReporting.Enabled = true;
          
            Uri sReportingLink = new Uri(Helpers.GetConfigEntry("ReportingServer"));
            HyperLinkReporting.NavigateUrl = "/TBI_Instruments/reports/ADHocReporting.aspx";// sReportingLink.ToString();
        }
        // If the session is timed out due to inactivity, redirect to the timeout screen
        if (Session["SessionTimedOut"] != null)
        {
            if (Session["SessionTimedOut"].ToString() == "true")
            {
                
            //    Response.Redirect("InstrumentTimeout.aspx");
            }
        }
    }

    public void SetDirtyFlag(bool flag)
    {

        dirtyFlag.Value = flag == true ? "1" : "0";


    }

    private bool AccessAllowed()
    {

        _currentUser = (UserAccountManager)HttpContext.Current.User;
        string myrolename = _currentUser.RoleName.ToString();
        if (myrolename.IndexOf("TBI Rehabilitation and Polytrauma Clinicians") > -1 )
        {
            return true;
        }
        else
        {
            return false;
        }
        //return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17) || _currentUser.IsInRole(18)|| _currentUser.IsInRole(413));
    }
    protected void Page_Init(object Sender, EventArgs e)
    {
        Response.Cache.SetCacheability(HttpCacheability.NoCache);
        Response.Cache.SetExpires(DateTime.Now.AddSeconds(-1));
        Response.Cache.SetNoStore();
    }

    private string GetContextSensitiveHelpURL()
    {
        return "~/help/" + Page.Page.ToString().Substring(4).Replace("_aspx", ".html").Replace("tbi_instruments_", "");
    }
}
